//
//  CRFramer.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 04/04/10.
//  Copyright 2009 Corner-A. All rights reserved.
//

#import "CRSceneItemVisual.h"
#import "CRSceneItemShadowGenerator.h"

@class CRMaterial;

extern NSString* const CRFramerFrameMaterialKey;
extern NSString* const CRFramerShadowsModeKey;

//////////////////////////////////////////////////////////////////////
// Frame generator
//////////////////////////////////////////////////////////////////////
@interface CRFramer : CRSceneItemVisual
{
@protected
	CRMaterial*		frameMaterial;
	CRShadowsMode	shadowsMode;
}

@property (nonatomic, strong) CRMaterial*	frameMaterial;
@property (nonatomic, assign) CRShadowsMode	shadowsMode;

@property (nonatomic, readonly)	BOOL		dropShadows;		// shadowsMode wrapper, signals whether there are shadows
@property (nonatomic, readonly)	BOOL		dropInnerShadows;	// shadowsMode wrapper, signals whether there are inner shadows
@property (nonatomic, readonly)	BOOL		dropOuterShadows;	// shadowsMode wrapper, signals whether there are outer shadows

// builder
+ (id)framer;

- (CGRect)innerRectForFrameRect:(CGRect)frameRect;
- (CIImage *)internalApplyProcessor:(CIImage *)internalInput transformOnly:(BOOL)transformOnly;

@end